<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Visualization extends Model 
{

    protected $table = 'visualizations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('file_url', 'panel_id');

    public function panel()
    {
        return $this->belongsTo('App\Models\Panel');
    }

}